using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a master mikael corpse" )]
	public class MasterMikael : BaseCreature
	{
		[Constructable]
		public MasterMikael() : base( AIType.AI_Necromage, FightMode.Closest, 10, 1, 0.015, 0.075 )
		{
			Name = "a master mikael";
			Hue = 0x8FD;
			Body = 0x94;
			BaseSoundID = 0x1C3;

			SetStr( 93, 122 );
			SetDex( 91, 100 );
			SetInt( 252, 271 );

			SetHits( 789, 1014 );

			SetDamage( 11, 19 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 55, 59 );
			SetResistance( ResistanceType.Fire, 40, 46 );
			SetResistance( ResistanceType.Cold, 72, 80 );
			SetResistance( ResistanceType.Poison, 44, 49 );
			SetResistance( ResistanceType.Energy, 50, 57 );

			SetSkill( SkillName.Wrestling, 80.1, 87.2 );
			SetSkill( SkillName.Tactics, 79.0, 90.9 );
			SetSkill( SkillName.MagicResist, 90.3, 106.9 );
			SetSkill( SkillName.Magery, 103.8, 108.0 );
			SetSkill( SkillName.EvalInt, 96.1, 105.3 );
			SetSkill( SkillName.Necromancy, 103.8, 108.0 );
			SetSkill( SkillName.SpiritSpeak, 96.1, 105.3 );
			
			if ( Utility.RandomBool() )
			{
				PackNecroScroll( Utility.RandomMinMax( 5, 9 ) );
         }
			else
				PackScroll( 4, 7 );
				
			PackReg( 3 );
			PackNecroReg( 1, 10 );
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosUltraRich );
		}
		
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );		
			
			if ( Utility.RandomDouble() < 0.30 )
			{
				Item item = new Klic();
				item.ItemID = 8826;
				item.Name = "Disintegrating Thesis Notes";
            c.DropItem( item );
         }
		}
		
		
	
		public MasterMikael( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}

